// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

import java.awt.*;
import java.net.*;
import java.awt.image.PixelGrabber;

/** Represents texture composed of a scaleable image. */
public class ImageTexture implements Texture
{
	/** Texture pixels. */
	private int[] pixel;
	/** Width of texture image. */
	private int width;
	/** Height of texture image. */
	private int height;

	/** Horizontal texture scale. */
	private float xScale = 1;
	/** Vertical texture scale. */
	private float yScale = 1;
	
	public Color getColor(float u, float v)
	{		
		// Return pixel color, wrapping value if needed
		return new Color(pixel[(int)(((u * xScale) % 1) * (width - 1) + (int)(((v * yScale) % 1) * (height - 1)) * width)]);
	}
	
	/** Constructs scaled image texture.
	 *  @param url        URL of image.
	 *  @param filename   filename of image.
	 *  @param initXScale horizontal scale of image when texture mapping.
	 *  @param initYScale vertical scale of image when texture mapping.
	 */
	public ImageTexture(URL url, String filename, float initXScale, float initYScale)
	{
		this(url, filename);

		xScale = initXScale;
		yScale = initYScale;
	}
	
	/** Constructs image texture of unit square size.
	 *  @param url      URL of image.
	 *  @param filename filename of image.
	 */
	public ImageTexture(URL url, String filename)
	{
		// Texture image
		Image image = null;
		
		try
		{
			// Get image from file
			image = Toolkit.getDefaultToolkit().getImage(new URL(url, filename));
		}
		catch (MalformedURLException e)
		{
		}

		// Add image to media tracker
		MediaTracker mediaTracker = new MediaTracker(new Panel());		
		mediaTracker.addImage(image, 0);
		
		try
		{
			// Wait for image to load
			mediaTracker.waitForAll();
		}
		catch (InterruptedException e)
		{
		}

		// If image failed to load
		if (mediaTracker.isErrorAny())
		{
			throw new RuntimeException("Error trying to load " + filename);
		}

		// Get image dimensions
		width  = image.getWidth(null);
		height = image.getHeight(null);

		// Create array for holding image pixels
		pixel = new int[width * height];

		// Create pixel grabber for grabbing image pixels
		PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width,  height, pixel, 0, width);

		try
		{
			// Grab image pixels
			pixelGrabber.grabPixels();
		}
		catch (InterruptedException e)
		{
			throw new RuntimeException("interrupted grabbing pixels");
		}
	}
}
