// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

/** Represents an intersection between a ray and a shape. */
public class Intersection
{
	/** Position intersection occurred. */
	private Vector3d position;
	/** Normal at intersection position on shape. */
	private Vector3d normal;
	/** Shape intersected with. */
	private Shape3d shape;
	/** Ray's t parameter value at intersection. */
	private float t;

	/** Constructs an intersection.
	 *  @param initShape    shape ray intersected with.
	 *  @param initPosition position intersection occured.
	 *  @param initT        ray's t parameter value at intersection.
	 *  @param initNormal   normal at intersection position on shape, facing towards ray origin.
	 */
	public Intersection(Shape3d initShape, Vector3d initPosition, float initT, Vector3d initNormal)
	{
		shape    = initShape;
		position = new Vector3d(initPosition);
		t        = initT;
		normal   = new Vector3d(initNormal);
	}

	/** Constructs an intersection.
	 *  @param initShape    shape ray intersected with.
	 *  @param ray          ray used.
	 *  @param initT        ray's t parameter value at intersection.
	 *  @param initNormal   normal at intersection position on shape, facing towards ray origin.
	 */
	public Intersection(Shape3d initShape, Ray ray, float initT, Vector3d initNormal)
	{
		shape    = initShape;
		position = ray.getPoint(initT);
		t        = initT;
		normal   = new Vector3d(initNormal);
	}

	/** Returns intersection position. */
	public Vector3d getPosition()
	{
		return new Vector3d(position);
	}

	/** Returns normal at intersection position on shape. */
	public Vector3d getNormal()
	{
		return new Vector3d(normal);
	}

	/** Returns shape ray intersected with. */
	public Shape3d getShape()
	{
		return shape;
	}

	/** Returns ray's t parameter value at intersection. */
	public float getT()
	{
		return t;
	}
}