// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

/** Represents a light source. */
public class Light
{
	/** Position of light source. */
	private Vector3d position;
	/** Intensity of light source. */
	private float intensity;

	/** Constructs a new light source. 
	 *  @param initPosition  position of light source.
	 *  @param initIntensity intensity of light source.
	 */
	public Light(Vector3d initPosition, float initIntensity)
	{
		position  = new Vector3d(initPosition);
		intensity = initIntensity;
	}

	/** Returns position of light source. */
	public Vector3d getPosition()
	{
		return new Vector3d(position);
	}

	/** Returns intensity of light source. */
	public float getIntensity()
	{
		return intensity;
	}
}