// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

/** Represents a ray. */
public class Ray
{
	/** Origin of ray. */
	private Vector3d position = new Vector3d();
	/** Direction of ray. */
	private Vector3d direction = new Vector3d();

	/** Constructs a new ray.
	 *  initPosition  origin of ray.
	 *  initDirection direction of ray.
	 */
	public Ray(Vector3d initPosition, Vector3d initDirection)
	{
		position  = new Vector3d(initPosition);
		direction = new Vector3d(initDirection);
	}

	/** Returns origin of ray. */
	public Vector3d getPosition()
	{
		return new Vector3d(position);
	}

	/** Returns direction of ray. */
	public Vector3d getDirection()
	{
		return new Vector3d(direction);
	}

	/** Returns point on ray at t distance from origin. */
	public Vector3d getPoint(float t)
	{
		return position.add(direction.multiply(t));
	}
}