// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

/** Represents description of scene to be raytraced. */
public class Scene
{
	/** Transformation to be applied to eye rays before they are traced. */
	Transform3d eyeTransform = new Transform3d();
	/** Distance view point is from view plane. */
	float viewPointDistance = 10;

	/** Width of view plane. */
	float viewWidth = 6;
	/** Height of view plane. */
	float viewHeight = viewWidth * 0.75f;
	
	/** List of shapes in scene. */
	Shape3d[] shapeList;
	/** List of lights in scene. */
	Light[] lightList;
	/** Ambient lighting. */
	float ambientLighting = 0;
}