// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

import java.awt.Color;

/** Represents a solid shape with an associated material. */
public abstract class Shape3d
{
	/** Material shape is made of. */
	private Material material;

	/** Constructs a new shape.
	 *  @param initMaterial material shape is made of.
	 */
	public Shape3d(Material initMaterial)
	{
		material = initMaterial;
	}

	/** Returns material of shape. */
	public Material getMaterial()
	{
		return material;
	}

	/** Returns intersection between ray and shape.
	 *  @param  ray       ray to use.
	 *  @param  threshold ray t parameter values below this value will not be considered in intersection test.
	 *  @return           intersection information.
	 */
	abstract public Intersection getIntersection(Ray ray, float threshold);
	
	/** Returns color of shape at a position. */
	abstract public Color getColor(Vector3d position);
}