// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

import java.awt.Color;

/** Represents a texture which has same color at every position. */
public class SolidColorTexture implements Texture
{
	/** Color of texture. */
	private Color color;
	
	/** Constructs a solid color texture.
	 *  @param initColor color of texture.
	 */
	public SolidColorTexture(Color initColor)
	{
		color = new Color(initColor.getRGB());	
	}
	
	public Color getColor(float u, float v)
	{
		return color;
	}
}