// ====================================================
//
// Copyright (c) 2001 Sean Wilson. All Rights Reserved.
//
// ====================================================

import java.awt.Color;

/** Represents a texture. */
public interface Texture
{
	/** Returns texture color at u/v co-ordinates.
	 *  @param u u co-ordinate, where 0.0 is the left side of texture and 1.0 is the right side.
	 *  @param v v co-ordinate, where 0.0 is the top of texture and 1.0 is the bottom side.
	 *  @return  texture color.
	 */
	public Color getColor(float u, float v);
}